# بصير / Bseer

موقع ويب احترافي متعدد اللغات (عربي/إنجليزي) لاستشارات الذكاء الاصطناعي عن بُعد مع دردشة ذكية للبيانات

## ✨ نظرة عامة

**بصير (Bseer)** هي منصة ذكاء اصطناعي متقدمة تمكنك من:
- 🤖 الدردشة المباشرة مع بياناتك من Odoo، Airtable، SQL، وGoogle Sheets
- 💼 الحصول على استشارات متخصصة من خبراء الذكاء الاصطناعي عن بُعد
- 📊 استخراج رؤى فورية من بياناتك دون الحاجة لخبرة تقنية
- 🔒 أمان عالي مع عدم تخزين بياناتك

## 🎨 المميزات الرئيسية

### تصميم احترافي متقدم
- ✅ تصميم حديث وعصري مع Glass Effect
- ✅ تدرجات لونية جذابة ومتطورة
- ✅ أنيميشن متقدمة وتأثيرات بصرية احترافية
- ✅ Particles Animation في الخلفية
- ✅ Smooth Scrolling والانتقالات السلسة
- ✅ Hover Effects متقدمة
- ✅ Custom Cursor Effect (للديسكتوب)
- ✅ Counter Animation للإحصائيات

### دعم متعدد اللغات
- 🌐 **العربية**: عرض الشعار "بصير" فقط
- 🌐 **الإنجليزية**: عرض الشعار "Bseer" فقط
- 🌐 تبديل سهل بين اللغات
- 🌐 دعم كامل لـ RTL و LTR

### تجربة مستخدم استثنائية
- 📱 Responsive Design - متوافق مع جميع الأجهزة
- ⚡ Performance Optimized - تحميل سريع
- 🎯 Interactive Forms مع Validation كامل
- 🔔 Toast Notifications جذابة
- 🎨 Modern UI/UX Design
- ♿ Accessibility Ready

## 📁 بنية الملفات

```
bswebsite/
│
├── index.html              # الصفحة الرئيسية (العربية)
├── about.html              # صفحة من نحن (العربية)
├── contact.html            # صفحة اتصل بنا (العربية)
├── login.html              # صفحة تسجيل الدخول (العربية)
├── signup.html             # صفحة إنشاء حساب (العربية)
│
├── index-en.html           # الصفحة الرئيسية (الإنجليزية)
├── about-en.html           # صفحة About (الإنجليزية) - قيد الإنشاء
├── contact-en.html         # صفحة Contact (الإنجليزية) - قيد الإنشاء
├── login-en.html           # صفحة Sign In (الإنجليزية) - قيد الإنشاء
├── signup-en.html          # صفحة Sign Up (الإنجليزية) - قيد الإنشاء
│
├── styles.css              # ملف التنسيقات الرئيسي
├── script.js               # ملف JavaScript مع الأنيميشن
└── README.md               # هذا الملف
```

## 🚀 البدء السريع

1. قم بتنزيل جميع الملفات في مجلد واحد
2. افتح ملف `index.html` (للعربية) أو `index-en.html` (للإنجليزية) في المتصفح
3. تصفح الموقع واستمتع بالتجربة!

## 🎯 الصفحات المتاحة

### النسخة العربية 🇸🇦

#### 1. الصفحة الرئيسية (index.html)
- Hero Section مع Particles Animation
- عداد إحصائيات متحرك
- عرض 4 مميزات رئيسية
- خطط الأسعار (الأساسية 199 ريال - الاحترافية 250 ريال)
- شرح آلية العمل في 4 خطوات
- CTA Section جذابة

#### 2. من نحن (about.html)
- Page Hero مع تأثيرات خلفية
- الرؤية والمهمة في بطاقات Glass Effect
- من نخدم (4 فئات)
- قيمنا (4 نقاط قوة)
- معلومات عن الفريق

#### 3. اتصل بنا (contact.html)
- معلومات التواصل في بطاقات تفاعلية
- نموذج تواصل شامل مع Validation
- خيارات متعددة لنوع الاستفسار
- تنسيق احترافي بتخطيط Grid

#### 4. تسجيل الدخول (login.html)
- تصميم Auth Page احترافي
- نموذج تسجيل دخول أنيق
- خيار "تذكرني" و"نسيت كلمة المرور"
- تسجيل عبر Google/Microsoft
- Password Toggle للعرض/الإخفاء

#### 5. إنشاء حساب (signup.html)
- نموذج تسجيل شامل
- Trial Badge مميز (7 أيام مجاناً)
- قائمة مميزات
- تسجيل عبر Google/Microsoft
- Validation كامل

### النسخة الإنجليزية 🇬🇧

#### 1. Home Page (index-en.html)
- النسخة الإنجليزية من الصفحة الرئيسية
- جميع المحتوى مترجم
- الشعار: **Bseer** فقط

## 🎨 نظام الألوان

### الألوان الرئيسية
```css
--primary: #6366f1           /* البنفسجي الأساسي */
--primary-dark: #4f46e5      /* البنفسجي الداكن */
--secondary: #ec4899         /* الوردي */
--accent: #f59e0b            /* الذهبي */
--success: #10b981           /* الأخضر */
```

### التدرجات
```css
--gradient-primary: linear-gradient(135deg, #667eea 0%, #764ba2 100%)
--gradient-blue: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%)
--gradient-gold: linear-gradient(135deg, #f6d365 0%, #fda085 100%)
--gradient-dark: linear-gradient(135deg, #1e3a8a 0%, #3b82f6 100%)
```

## 🔧 التقنيات المستخدمة

### Frontend
- **HTML5**: بنية صفحات دلالية
- **CSS3**: تنسيقات متقدمة
  - CSS Variables للألوان والقيم
  - Flexbox & Grid للتخطيط
  - Animations & Transitions
  - Glass Morphism Effect
  - Backdrop Filters
  - Gradient Backgrounds

### JavaScript
- **Vanilla JS**: بدون إطار عمل
  - Particles Animation
  - Counter Animation
  - Scroll Reveal
  - Form Validation
  - Mobile Navigation
  - Smooth Scrolling
  - Custom Cursor Effect
  - Password Toggle
  - Toast Notifications

### External Libraries
- **Font Awesome 6.4.0**: الأيقونات
- **Google Fonts**: 
  - Tajawal (للعربية)
  - Inter (للإنجليزية)

## 🎭 الأنيميشن والتأثيرات

### Animations المستخدمة
1. **Fade In / Fade Out**: للظهور والاختفاء
2. **Fade In Up**: للعناصر الصاعدة
3. **Scale In**: للتكبير التدريجي
4. **Float**: للجزيئات المتحركة
5. **Shine**: لتأثير اللمعان
6. **Scroll**: لمؤشر التمرير
7. **Hover Transforms**: للبطاقات والأزرار
8. **Counter Animation**: للأرقام
9. **Particles Animation**: للخلفية

### تأثيرات بصرية
- Glass Morphism
- Gradient Overlays
- Box Shadows متعددة المستويات
- Backdrop Blur
- Border Gradients
- Custom Cursor (Desktop)

## 📱 التجاوب (Responsive)

### نقاط التوقف (Breakpoints)
```css
@media (max-width: 1024px) { /* Tablets */ }
@media (max-width: 768px)  { /* Mobile Landscape */ }
@media (max-width: 640px)  { /* Mobile Portrait */ }
@media (max-width: 480px)  { /* Small Mobile */ }
```

### مميزات التجاوب
- Hamburger Menu للهواتف
- Grid Layouts تتكيف تلقائياً
- Typography Scaling
- Touch-Friendly Buttons
- Optimized Spacing

## 📞 معلومات التواصل

- **البريد الإلكتروني**: info@sitoweb.io
- **الهاتف**: +966 507143069
- **ساعات العمل**: الأحد - الخميس (9ص - 6م)

## 🔐 الأمان والخصوصية

- ✅ لا نخزن بياناتك
- ✅ الاتصال مؤقت ومشفّر
- ✅ Form Validation من الجانب الأمامي
- ✅ Secure Connections فقط

## 🚀 الأداء (Performance)

### تحسينات الأداء
- Lazy Loading للعناصر
- CSS/JS مُحسّن
- Font Optimization
- Minimal External Dependencies
- Smooth 60fps Animations

## 🌟 الميزات المتقدمة

### Form Features
- ✅ Real-time Validation
- ✅ Password Strength Indicator (قابل للإضافة)
- ✅ Password Toggle (Show/Hide)
- ✅ Error Messages
- ✅ Success Notifications

### UX Features
- ✅ Scroll to Top Button (قابل للإضافة)
- ✅ Loading States
- ✅ Skeleton Screens (قابل للإضافة)
- ✅ Smooth Page Transitions
- ✅ Interactive Feedback

## 📋 قائمة المهام

### ✅ تم الإنجاز
- [x] تصميم الصفحة الرئيسية (عربي/إنجليزي)
- [x] تصميم صفحة من نحن (عربي)
- [x] تصميم صفحة اتصل بنا (عربي)
- [x] تصميم صفحة تسجيل الدخول (عربي)
- [x] تصميم صفحة إنشاء حساب (عربي)
- [x] نظام الأنيميشن المتقدم
- [x] Particles Animation
- [x] Counter Animation
- [x] Form Validation
- [x] Mobile Navigation
- [x] Toast Notifications

### 🔄 قيد العمل
- [ ] النسخة الإنجليزية الكاملة (about, contact, login, signup)
- [ ] Dashboard للمستخدمين
- [ ] صفحة الأسعار المخصصة
- [ ] صفحة الأسئلة الشائعة (FAQ)
- [ ] Blog/Articles Section

### 🎯 المخطط لها
- [ ] Backend Integration (API)
- [ ] Authentication System
- [ ] Payment Gateway Integration
- [ ] Analytics Dashboard
- [ ] Email Notifications
- [ ] Dark Mode
- [ ] Multi-language Support (توسيع)

## 💻 متطلبات التشغيل

- متصفح حديث يدعم:
  - CSS Grid & Flexbox
  - CSS Variables
  - ES6 JavaScript
  - Backdrop Filters
  - CSS Animations

### المتصفحات المدعومة
- ✅ Chrome (آخر إصدارين)
- ✅ Firefox (آخر إصدارين)
- ✅ Safari (آخر إصدارين)
- ✅ Edge (آخر إصدارين)

## 📝 ملاحظات التطوير

### Best Practices المُتبعة
- Semantic HTML5
- BEM CSS Methodology (جزئياً)
- Mobile-First Approach
- Progressive Enhancement
- Accessibility Considerations
- Clean Code Principles

### Code Organization
- CSS Variables للقيم المتكررة
- Modular JavaScript Functions
- Commented Code
- Consistent Naming Conventions

## 🤝 المساهمة

هذا المشروع تم تطويره خصيصاً لـ **بصير (Bseer)**.

## 📄 الترخيص

© 2025 بصير (Bseer) - جميع الحقوق محفوظة

---

## 🎉 شكر خاص

تم تطوير هذا الموقع باستخدام أحدث تقنيات الويب مع التركيز على:
- تجربة المستخدم الاستثنائية
- التصميم الحديث والاحترافي
- الأداء العالي
- الأمان والخصوصية

**للدعم الفني**: info@sitoweb.io

---

**تم التطوير بواسطة فريق بصير المتخصص** 🚀
