# 🎨 دليل التخصيص - Customization Guide

هذا الدليل يشرح كيفية تخصيص موقع بصير (Bseer) حسب احتياجاتك.

## 🎨 تغيير الألوان

### الطريقة 1: تعديل المتغيرات في CSS

افتح ملف `styles.css` وابحث عن قسم `:root` في البداية وقم بتعديل الألوان:

```css
:root {
    /* الألوان الأساسية */
    --primary: #6366f1;           /* لون أساسي جديد */
    --primary-dark: #4f46e5;      /* نسخة داكنة */
    --secondary: #ec4899;         /* لون ثانوي */
    --accent: #f59e0b;            /* لون مميز */
    
    /* التدرجات */
    --gradient-primary: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    /* غيّر القيم الست عشرية للألوان حسب رغبتك */
}
```

### الطريقة 2: إنشاء ثيمات ملونة

أضف في نهاية ملف `styles.css`:

```css
/* ثيم أزرق */
.theme-blue {
    --primary: #0ea5e9;
    --primary-dark: #0284c7;
    --gradient-primary: linear-gradient(135deg, #06b6d4 0%, #3b82f6 100%);
}

/* ثيم أخضر */
.theme-green {
    --primary: #10b981;
    --primary-dark: #059669;
    --gradient-primary: linear-gradient(135deg, #34d399 0%, #10b981 100%);
}

/* ثيم ذهبي */
.theme-gold {
    --primary: #f59e0b;
    --primary-dark: #d97706;
    --gradient-primary: linear-gradient(135deg, #fbbf24 0%, #f59e0b 100%);
}
```

ثم أضف الكلاس للعنصر `<body>`:
```html
<body class="rtl theme-blue">
```

## 📝 تغيير النصوص

### تعديل محتوى الصفحة الرئيسية

افتح ملف `index.html` أو `index-en.html` وابحث عن النص الذي تريد تغييره:

```html
<!-- مثال: تغيير العنوان الرئيسي -->
<h1 class="hero-title animate-fade-in-up">
    استشارات ذكاء اصطناعي عن بُعد
    <span class="gradient-text">+ دردشة مباشرة مع بياناتك</span>
</h1>
```

### تعديل معلومات التواصل

ابحث عن قسم Footer في جميع الصفحات:

```html
<ul class="contact-list">
    <li>
        <i class="fas fa-envelope"></i>
        <a href="mailto:your@email.com">your@email.com</a>
    </li>
    <li>
        <i class="fas fa-phone"></i>
        <a href="tel:+1234567890">+123 456 7890</a>
    </li>
</ul>
```

## 🔤 تغيير الخطوط

### للنسخة العربية

في ملف HTML، قم بتغيير رابط Google Fonts:

```html
<!-- الخط الحالي: Tajawal -->
<link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;700;900&display=swap" rel="stylesheet">

<!-- خطوط بديلة عربية -->
<!-- Cairo -->
<link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;500;700;900&display=swap" rel="stylesheet">

<!-- IBM Plex Sans Arabic -->
<link href="https://fonts.googleapis.com/css2?family=IBM+Plex+Sans+Arabic:wght@300;400;500;700&display=swap" rel="stylesheet">

<!-- Almarai -->
<link href="https://fonts.googleapis.com/css2?family=Almarai:wght@300;400;700;800&display=swap" rel="stylesheet">
```

ثم في `styles.css`:

```css
:root {
    --font-primary: 'Cairo', -apple-system, sans-serif;
    /* أو */
    --font-primary: 'IBM Plex Sans Arabic', sans-serif;
    /* أو */
    --font-primary: 'Almarai', sans-serif;
}
```

### للنسخة الإنجليزية

```html
<!-- الخط الحالي: Inter -->
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">

<!-- خطوط بديلة إنجليزية -->
<!-- Poppins -->
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">

<!-- Montserrat -->
<link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
```

## 🖼️ إضافة الشعار (Logo)

### باستخدام صورة

في `index.html` استبدل:

```html
<!-- من -->
<div class="logo">بصير</div>

<!-- إلى -->
<div class="logo">
    <img src="images/logo-ar.png" alt="بصير" style="height: 40px;">
</div>
```

في `index-en.html`:

```html
<div class="logo">
    <img src="images/logo-en.png" alt="Bseer" style="height: 40px;">
</div>
```

### تنسيق الشعار في CSS

```css
.logo img {
    height: 40px;
    width: auto;
    object-fit: contain;
    transition: var(--transition-base);
}

.logo img:hover {
    transform: scale(1.05);
}
```

## 📊 تخصيص الإحصائيات

في ملف `index.html` أو `index-en.html`:

```html
<div class="hero-stats animate-fade-in-up delay-3">
    <div class="stat-item">
        <div class="stat-number" data-count="500">0</div>
        <div class="stat-label">عميل راضٍ</div>
    </div>
    <!-- غيّر القيمة في data-count -->
    <div class="stat-item">
        <div class="stat-number" data-count="2000">0</div>
        <div class="stat-label">استشارة ناجحة</div>
    </div>
</div>
```

## 💰 تخصيص الأسعار

في قسم Pricing:

```html
<div class="pricing-price">
    <span class="currency">ريال</span>
    <span class="amount">199</span> <!-- غيّر السعر هنا -->
    <span class="period">/شهرياً</span>
</div>
```

إضافة أو حذف مميزات:

```html
<ul class="pricing-features">
    <li>
        <i class="fas fa-check-circle"></i>
        <span>ميزة جديدة هنا</span>
    </li>
    <!-- أضف المزيد من الميزات -->
</ul>
```

## 🎭 تخصيص الأنيميشن

### تغيير سرعة الأنيميشن

في `styles.css`:

```css
:root {
    /* السرعة الحالية */
    --transition-base: 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    
    /* أسرع */
    --transition-base: 0.15s cubic-bezier(0.4, 0, 0.2, 1);
    
    /* أبطأ */
    --transition-base: 0.5s cubic-bezier(0.4, 0, 0.2, 1);
}
```

### تعطيل/تفعيل Particles

في `script.js`:

```javascript
// للتعطيل، علّق السطر التالي:
// createParticles();

// أو قم بتغيير عدد الجزيئات:
const particleCount = 30; // بدلاً من 50
```

### تخصيص تأثيرات الـ Hover

```css
.feature-card:hover {
    transform: translateY(-10px); /* غيّر المسافة */
    box-shadow: var(--shadow-2xl);
}

/* تأثير دوران */
.feature-card:hover {
    transform: translateY(-10px) rotate(2deg);
}

/* تأثير تكبير */
.feature-card:hover {
    transform: scale(1.05);
}
```

## 📱 تخصيص نقاط التوقف (Breakpoints)

في `styles.css`:

```css
/* غيّر نقاط التوقف حسب احتياجك */
@media (max-width: 1200px) { /* بدلاً من 1024px */ }
@media (max-width: 900px)  { /* بدلاً من 768px */ }
@media (max-width: 600px)  { /* بدلاً من 480px */ }
```

## 🔔 تخصيص الإشعارات (Notifications)

في `script.js`:

```javascript
function showNotification(message, type = 'success') {
    // غيّر الألوان
    background: ${type === 'success' ? 
        'linear-gradient(135deg, #10b981 0%, #059669 100%)' : 
        'linear-gradient(135deg, #ef4444 0%, #dc2626 100%)'
    };
    
    // غيّر المدة (بالميلي ثانية)
    setTimeout(() => {
        // ...
    }, 5000); // بدلاً من 3000
}
```

## 🌐 إضافة روابط Social Media

في قسم Footer:

```html
<div class="social-links">
    <a href="https://twitter.com/yourusername" target="_blank">
        <i class="fab fa-twitter"></i>
    </a>
    <a href="https://linkedin.com/company/yourcompany" target="_blank">
        <i class="fab fa-linkedin"></i>
    </a>
    <a href="https://facebook.com/yourpage" target="_blank">
        <i class="fab fa-facebook"></i>
    </a>
    <a href="https://instagram.com/yourusername" target="_blank">
        <i class="fab fa-instagram"></i>
    </a>
    <!-- أضف المزيد -->
    <a href="https://youtube.com/yourchannel" target="_blank">
        <i class="fab fa-youtube"></i>
    </a>
</div>
```

## 📝 إضافة صفحات جديدة

### خطوات إنشاء صفحة جديدة:

1. **انسخ ملف موجود** (مثل `about.html`)
2. **غيّر المحتوى** حسب الحاجة
3. **حدّث Navigation** في جميع الصفحات:

```html
<div class="nav-menu" id="navMenu">
    <!-- ... الروابط الموجودة ... -->
    <a href="your-new-page.html" class="nav-link">صفحتك الجديدة</a>
</div>
```

4. **حدّث Footer** في جميع الصفحات:

```html
<ul>
    <li><a href="your-new-page.html">صفحتك الجديدة</a></li>
</ul>
```

## 🎨 إضافة قسم جديد في الصفحة

قالب لقسم جديد:

```html
<section class="your-section section-padding">
    <div class="container">
        <div class="section-header">
            <span class="section-tag">العنوان الفرعي</span>
            <h2 class="section-title">العنوان الرئيسي</h2>
            <p class="section-subtitle">الوصف هنا</p>
        </div>
        
        <div class="your-content">
            <!-- المحتوى هنا -->
        </div>
    </div>
</section>
```

## 🔧 نصائح التخصيص

### 1. استخدم Developer Tools
- اضغط `F12` في المتصفح
- اختبر التغييرات مباشرة
- تفقّد Responsive Design

### 2. احتفظ بنسخة احتياطية
قبل أي تعديلات كبيرة، احفظ نسخة من الملفات

### 3. اختبر على متصفحات مختلفة
- Chrome
- Firefox
- Safari
- Edge

### 4. اختبر على أجهزة مختلفة
- Desktop
- Tablet
- Mobile

### 5. استخدم أدوات مساعدة
- **Color Picker** لاختيار الألوان
- **Google Fonts** لاختيار الخطوط
- **FontAwesome** للأيقونات

## 🆘 حل المشاكل الشائعة

### المشكلة: الخط لا يظهر
**الحل**: تأكد من رابط Google Fonts في قسم `<head>`

### المشكلة: الألوان لم تتغير
**الحل**: امسح الـ Cache (Ctrl + Shift + R)

### المشكلة: الأنيميشن لا تعمل
**الحل**: تأكد من تحميل ملف `script.js` في نهاية `<body>`

### المشكلة: القائمة لا تعمل على الموبايل
**الحل**: تأكد من أن JavaScript يعمل وتحقق من Console للأخطاء

## 📚 موارد مفيدة

- **الألوان**: [coolors.co](https://coolors.co)
- **التدرجات**: [cssgradient.io](https://cssgradient.io)
- **الأيقونات**: [fontawesome.com](https://fontawesome.com)
- **الخطوط**: [fonts.google.com](https://fonts.google.com)
- **الصور**: [unsplash.com](https://unsplash.com)

---

## 📧 الدعم الفني

لأي استفسارات أو مساعدة في التخصيص:
**البريد الإلكتروني**: info@sitoweb.io

---

**بالتوفيق في تخصيص موقعك!** 🎉

